import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/components/layout.dart';
import 'package:photogram_admin_cp/ui/pages/administration/site/app_update_settings.dart';
import 'package:photogram_admin_cp/ui/pages/administration/site/general_site_settings.dart';

class SiteSettingsPage extends StatefulWidget {
  const SiteSettingsPage({Key? key}) : super(key: key);

  @override
  _SiteSettingsPageState createState() => _SiteSettingsPageState();
}

class _SiteSettingsPageState extends State<SiteSettingsPage> with AppActiveContentMixin {
  NavigatorState? _state;
  String _currentRoute = 'general';

  @override
  build(context) {
    return PageRow(
      children: [
        Division(
          className: 'col-lg-6',
          child: navigatorContent(),
        ),
        Division(
          className: 'col-lg-3',
          children: [
            Division(
              className: 'content-sidebar',
              children: [
                Division(
                  className: 'on-this-page-nav',
                  children: [
                    const Division(className: 'title font-size-18', innerText: 'Site Settings'),
                    Anchor(
                      className: _currentRoute == 'general' ? 'active' : '',
                      innerText: 'General Site Settings',
                      onClick: (_) => _openRoute('general'),
                    ),
                  ],
                ),
                const LineBreak(),
                Division(
                  className: 'on-this-page-nav',
                  children: [
                    const Division(className: 'title font-size-18', innerText: 'Mobile App Settings'),
                    Anchor(
                      className: _currentRoute == 'update' ? 'active' : '',
                      innerText: 'App Update Settings',
                      onClick: (_) => _openRoute('update'),
                    ),
                  ],
                ),
              ],
            ),
          ],
        ),
      ],
    );
  }

  Widget navigatorContent() {
    return Navigator(
      key: const Key('site-settings-navigator'),
      onInit: (state) => _state = state,
      onRouteChange: _onRouteChange,
      routes: const [
        Route(name: 'general', page: GeneralSiteSettingsSection()),
        Route(name: 'update', page: AppUpdateSettingsSection()),
      ],
    );
  }

  void _openRoute(String name, [Map<String, String> values = const {}]) {
    _state?.open(name: name, values: values);
  }

  void _onRouteChange(String name) {
    Future.delayed(Duration.zero, () {
      setState(() {
        _currentRoute = name;
      });
    });
  }
}
